/*----------------------------------------------------------------------

  PilotMain.c

  ----------------------------------------------------------------------

  Copyright (C). 2003 Smoky Monkey Factory All Rights Reserved
  http://andmore.jp/mobile/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: PilotMain.c,v 1.5 2003/07/20 01:58:38 zxn Exp $

  ----------------------------------------------------------------------*/

#include <PalmOS.h>
#include "SnapClip.h"
#include "Etc.h"
#include "NotifyHandler.h"
#include "SnapClip.h"
#include "Prefs.h"


static void _handleActivation(void); /* xxxx */

/* The main event loop */
static void EventLoop(void)
{
    UInt16 err;
    EventType e;

    do {
        EvtGetEvent(&e, evtWaitForever);
        if (! SysHandleEvent (&e))
            if (! MenuHandleEvent (NULL, &e, &err))
                if (! ApplicationHandleEvent (&e))
                    FrmDispatchEvent (&e);
    } while (e.eType != appStopEvent);
}

/* Main entry point; it is unlikely you will need to change this except to
   handle other launch command codes */
UInt32 PilotMain(UInt16 cmd, MemPtr cmdPBP, UInt16 launchFlags)
{
    UInt16 err;
    UInt16 card_no;
    LocalID db_id;

    switch(cmd)
      {
      case sysAppLaunchCmdNormalLaunch:
        err = StartApplication();
        if (err) return err;

        EventLoop();
        StopApplication();
	break;

      case sysAppLaunchCmdSystemReset:
	SysCurAppDatabase(&card_no, &db_id);
	AlmSetAlarm(card_no, db_id, 0, TimGetSeconds(), false);
   	break;

      case sysAppLaunchCmdAlarmTriggered:
	_handleActivation();
	break;

      default:
        return sysErrParamErr;
      }

    return 0;
}

/*----------------------------------------------------------------------
  ask activation of the app
  ----------------------------------------------------------------------*/
static void _handleActivation(void) /* xxxx */
{
  prefsObj prefs;
  Boolean enabled = false;
  prefsAutoActivateIdx activate_idx;

  if ((prefs = prefs_New()) == NULL) 
    return;  

  activate_idx = prefs_GetAutoActivate(prefs);

  if ((activate_idx == PREFS_AUTO_ACTIVATE_YES) ||
      ((activate_idx == PREFS_AUTO_ACTIVATE_ASK) &&
       (FrmAlert(ASK_ACTIVATE_FORM_ID) ==  0)))
    {
      enabled = true;
      app_enableHack();
    }	
  else
    {
      enabled = false;
      app_disableHack();
    }

  prefs_SetEnabled(prefs, enabled);  
  prefs_SetFldEnter(prefs, false);

  prefs_Save(prefs);
  prefs_Delete(prefs);
}

